#ifndef UTIL_H
#define UTIL_H

#include <QString>
#include "typedef.h"

bool isint(LD v);
bool isregint(const LD &v);
bool isregintrange(const LD &v);
bool candms(const LD &v);
char *newasutf8(QString s);
long toLongRobust(QString s, bool &ok);
LD toLDRobust(QString s, bool &ok);
LC intpow(LC y,qint64 x);
LC introot(LC y,qint64 x);
QString chext(QString name, QString ext);
QString appName();
QString nodir(QString name);
QString justdir(QString name);
QString appPath();
QString snumber(qint64 v, WordLength wl, RadixType r); // instead of QString::number, with signed ints of specified wordlength
LD getreal(LC v);
LD getimag(LC v);
bool isreal(LC v);

// file/help etc.
void SetHelpDirDflt(); // gets application dir and adds html/
void SetHelpDir(QString); // set another dir
void ShowHelp(QString);
void SendMail(QString);

// missing std::functions - solved before, so I do it again... Easier this time, with proper complex arithmetic!
LC xcasin(LC x);
LC xcacos(LC x);
LC xcatan(LC x);
LC xcarsinh(LC x);
LC xcarcosh(LC x);
LC xcartanh(LC x);

// system constants

const QString EXTSEP = ".";
const QString PATHSEP = "/";

extern QString g_helpdir;

#endif // UTIL_H
