/*
	QTXCALC simple RPN Calculator
	Copyright (C) 1992-2012  Bernt Ribbum

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "xcalc.h"
#include "qengine.h"

QTXCalcApp::QTXCalcApp(int argc, char *argv[]):QApplication(argc,argv) {
	m_qengine = new QEngine(this);
	m_profile = new Profile(appName(),0);
	ReadProfile();

}

QTXCalcApp::~QTXCalcApp() {
	SaveProfile();
	delete m_profile;
}

void QTXCalcApp::ReadProfile(){
	Register::setWordLength((WordLength)m_profile->readInt("WordLength",Register::wordLength()));
	m_qengine->m_xengine->setradixtype((RadixType)m_profile->readInt("Radix",m_qengine->m_xengine->radixtype()));
	m_qengine->m_xengine->setcleanfrac(m_profile->readBool("CleanFrac",m_qengine->m_xengine->cleanfrac()));
	m_qengine->m_xengine->setfixtype((FixType)m_profile->readInt("FixType",m_qengine->m_xengine->fixtype()));
	m_qengine->m_xengine->setfix(m_profile->readInt("Fix",m_qengine->m_xengine->fix()));
}

void QTXCalcApp::SaveProfile(){
	m_profile->write("WordLength",(int)Register::wordLength());
	m_profile->write("Radix",(int)m_qengine->m_xengine->radixtype());
	m_profile->write("CleanFrac",m_qengine->m_xengine->cleanfrac());
	m_profile->write("FixType",(int)m_qengine->m_xengine->fixtype());
	m_profile->write("Fix",m_qengine->m_xengine->fix());
}
